--TODO: tee nist moduuleja joita voi kytt luokkien tapaan...
require 'g_level'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("trees_0", "data/images/trees0.png",h, WM_REPEAT,WM_REPEAT,AM_MODULATE);	
lua_init_texture("trees_1", "data/images/trees1.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("trees_2", "data/images/trees2.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("fence", "data/images/fence.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("statue", "data/images/statue.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("lantern", "data/images/lantern.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("purple_flame", "data/images/purple_flame.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("circle", "data/images/circle3.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("particle", "data/images/particle.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("button_idle", "data/images/button_idle.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("button_highlight", "data/images/button_highlight.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
--lua_init_texture("font", "data/images/font.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)
--lua_init_texture("small_font", "data/images/small_font.png",h,WM_CLAMP,WM_CLAMP,AM_MODULATE)

--INIT SUBTEXTURES  --adds a subtexture into the ObjectManager<SubTexture>
lua_init_subtextures("purple_flame",8,1,1,5) -- using a selfmade lua function to initialize
lua_init_subtextures("particle",4,4,1,14)

--INIT ANIMATIONS   -- adds a animation into the ObjectManager<Animation>
lua:init_animation("purple_flame",MODE_LOOP, DIRECTION_FORWARD)
lua:animation_add_frame("purple_flame","purple_flame_1", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_2", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_3", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_4", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_5", 0.125)

lua:init_animation("particle", MODE_ONCE, DIRECTION_FORWARD)
local k = 0.075
lua:animation_add_frame("particle","particle_1",k)
lua:animation_add_frame("particle","particle_2",k)
lua:animation_add_frame("particle","particle_3",k)
lua:animation_add_frame("particle","particle_4",k)
lua:animation_add_frame("particle","particle_5",k)
lua:animation_add_frame("particle","particle_6",k)
lua:animation_add_frame("particle","particle_7",k)
lua:animation_add_frame("particle","particle_8",k)
lua:animation_add_frame("particle","particle_9",k)
lua:animation_add_frame("particle","particle_10",k)
lua:animation_add_frame("particle","particle_11",k)
lua:animation_add_frame("particle","particle_12",k)
lua:animation_add_frame("particle","particle_13",k)
lua:animation_add_frame("particle","particle_14",k)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.25,0.25,BM_DEFAULT) -- 1
lua:create_layer(0.5,0.5,BM_DEFAULT) -- 2
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 3
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 4
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 5

--CREATE GAMEOBJECTS
-- Create Textured Sprites
lua:create_sprite("background", ST_TEXTURED,"trees_0", 0.0, -32.0)  --name: only used in creation and neglegted afterwards. texture: the name of the texture added to the sprite. float values are translation values.
lua:sprite_shape("background",ST_TEXTURED,256.0*4, 128.0*4) --name: name  of the object. shape values.
lua:textured_sprite_tex_coords("background", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)  --name: name of the object. the texture coordinate values.
--lua:gameobject_upload("background",0)  --this adds the gameobject to the real layer,and removes it from the temporary collection. name: name of the object. index: the index of the layer in which to add.
g_level.upload("background",0)

lua:create_sprite("fartrees", ST_TEXTURED,"trees_1", 0.0, -32.0) 
lua:sprite_shape("fartrees",ST_TEXTURED,256.0, 64.0)
lua:textured_sprite_tex_coords("fartrees", ST_TEXTURED,0.0, 0.0, 2.0, 1.0)
g_level.upload("fartrees",1) 

lua:create_sprite("neartrees", ST_TEXTURED,"trees_2", 0.0, 112.0) 
lua:sprite_shape("neartrees",ST_TEXTURED,512.0, 256.0)
lua:textured_sprite_tex_coords("neartrees", ST_TEXTURED,0.0, 0.0, 8.0, 1.0)
g_level.upload("neartrees",2) 

lua:create_sprite("fence", ST_TEXTURED,"fence", 0.0, -96.0) 
lua:sprite_shape("fence",ST_TEXTURED,1024.0, 32.0)
lua:textured_sprite_tex_coords("fence", ST_TEXTURED,0.0, 0.0, 32.0, 1.0)
g_level.upload("fence",4) 

lua:create_sprite("rstatue", ST_TEXTURED,"statue", -160.0, -32.0) 
lua:sprite_shape("rstatue",ST_TEXTURED,64.0, 64.0)
lua:textured_sprite_tex_coords("rstatue", ST_TEXTURED,1.0, 0.0, 0.0, 1.0)
g_level.upload("rstatue",4) 

lua:create_sprite("lstatue", ST_TEXTURED,"statue", 160.0, -32.0) 
lua:sprite_shape("lstatue",ST_TEXTURED,64.0, 64.0)
lua:textured_sprite_tex_coords("lstatue", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)
g_level.upload("lstatue",4) 

lua:create_sprite("lanterm", ST_TEXTURED,"lanterm", 0.0, -64.0) 
lua:sprite_shape("lstatue",ST_TEXTURED,16.0, 32.0)
lua:textured_sprite_tex_coords("lstatue", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)
g_level.upload("lstatue",4) 

--Create Scrolling Sprite

lua:create_sprite("background", ST_SCROLLING,"trees_0", -256.0, -256.0)  --name: only used in creation and neglegted afterwards. texture: the name of the texture added to the sprite. float values are translation values.
lua:sprite_shape("background",ST_SCROLLING,256.0, 128.0) --name: name  of the object. shape values.
lua:textured_sprite_tex_coords("background", ST_SCROLLING,0.0, 0.0, 1.0, 1.0)  --name: name of the object. the texture coordinate values.
lua:scrolling_sprite("background", SS_HORIZONTAL, 0.2) -- name. type of scrolling. scrolling speed
g_level.upload("background",0)  --this adds the gameobject to the real layer,and removes it from the temporary collection. name: name of the object. index: the index of the layer in which to add.


--Create Buttons
lua:create_sprite("bidle_1", ST_TEXTURED,"button_idle", 160.0, -32.0) 
lua:sprite_shape("bidle_1",ST_TEXTURED,64.0, 23.0)
lua:textured_sprite_tex_coords("bidle_1", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)

lua:create_sprite("bhighlight_1", ST_TEXTURED,"button_highlight", 160.0, -32.0) 
lua:sprite_shape("bhighlight_1",ST_TEXTURED,64.0, 23.0)
lua:textured_sprite_tex_coords("bhighlight_1", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)

lua:create_sprite("bidle_2", ST_TEXTURED,"button_idle", 160.0, 0.0) 
lua:sprite_shape("bidle_2",ST_TEXTURED,64.0, 23.0)
lua:textured_sprite_tex_coords("bidle_2", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)

lua:create_sprite("bhighlight_2", ST_TEXTURED,"button_highlight", 160.0, 0.0) 
lua:sprite_shape("bhighlight_2",ST_TEXTURED,64.0, 23.0)
lua:textured_sprite_tex_coords("bhighlight_2", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)

lua:create_button("button_1","bidle_1","bhighlight_1","data/music/effect_stereo.ogg","","")    -- name: the button name. texture_idle: the texture shown when idle. texture_highlight: the texture shown when focus. press_sound, change_sound, script: the scipt file to be done when pressing the button
lua:create_button("button_2","bidle_2","bhighlight_2","","","data/scripts/lvl_forest.lua")

lua:button_dependencies("button_1","","button_2","","")  --name: button name. button_up. button_down. button_left. button_right.
lua:button_dependencies("button_2","button_1","","","")

lua:set_focused_button("button_1")  --Button to be focused. Must be done before upload...

g_level.upload("button_1",4) 
g_level.upload("button_2",4) 

--Create Emitter

--create the particle
--lua:create_sprite("prototype", ST_PARTICLE, "circle", 0,0)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
--lua:sprite_shape("prototype", ST_PARTICLE, 4.0,4.0)
--lua:textured_sprite_tex_coords("prototype", ST_PARTICLE, 0.0, 0.0, 1.0, 1.0)
--lua:particle_start_color("prototype", 1.0, 1.0, 1.0, 0.5) -- name: rgba-colors
--lua:particle_end_color("prototype", 0.0, 0.0, 0.0, 0.0)
lua:create_sprite("prototype", ST_ANIMATED_PARTICLE, "particle", 0,0)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
lua:sprite_shape("prototype", ST_ANIMATED_PARTICLE, 4.0,4.0)
lua:particle_start_color("prototype", 1.0, 1.0, 1.0, 0.5) -- name: rgba-colors
lua:particle_end_color("prototype", 0.0, 0.0, 0.0, 0.0)

-- create the emitter
lua:create_sprite("emitter", ST_EMITTER, "prototype", 0,0) -- the translation values are on, the "texture" is the teztured particle inserted.
lua:emitter_range("emitter", 0.75, 1.5, -5.0, 5.0, 25.0, 75.0)  --life, angular_velocity, linear_velocity
lua:emitter_scale("emitter", true, 1.0, 3.0, 2.0, 4.0)  -- variable_scale, begin_scale_range, end_scale_range
--lua:emitter_target_layer("emitter", 5) -- target layer index
lua:emitter_angle("emitter", 3.14) -- angle. (0-PI)
lua:emitter_timer_delay("emitter", 0.001) -- the new timer delay
lua:remorfable_sprite("p", "emitter", 0.1, true)             -- name, sprite_name, speed, repeat

lua:add_key_frame(1, 128.0 , 128.0, 1.0 , 1.0)  -- adds a new key frame. time, x, y, rotation, scale
lua:add_key_frame_color(1.0,0.0,0.0,0.0)  -- r,g,b,a
lua:upload_key_frame("p")
g_level.upload("p", 0)                                    

--Segments Start
lua:create_segment(-1200.0,-120.0,-500.0,-120.0) --creates a new segment. startpoint x1 & y1, endpoint x2 & y2
lua:add_segment(-450.0,-90.0) --adds to the previous segment, using the end point of the previous segment as the starting point, only giving the end point.
lua:add_segment(-400.0,-85.0)
lua:add_segment(-350.0,-90.0)
lua:add_segment(-300.0,-120.0)
lua:add_segment(-100.0,-120.0)
lua:add_segment(0.0,0.0)
lua:add_segment(50.0,0.0)
lua:upload_segmentstrip()

lua:create_segment(100.0, 0.0, 150.0, 0.0)
lua:add_segment(300.0,-120.0)
lua:add_segment(500.0,-120.0)
lua:upload_segmentstrip()

lua:create_segment(-400.0, 0.0, -300.0, 50.0)
lua:add_segment(-200.0, 0.0)
lua:upload_segmentstrip()

lua:create_segment(-200.0, 100.0, -100.0, 150.0)
lua:add_segment(0.0, 100.0)
lua:upload_segmentstrip()
--Segmetns End


--unstablefloor start
lua:unstablefloor_create(1000, 10.0, 3.0,4) --code, appeartime, disappeartime (in seconds)

lua:create_segment_with_code(100.0, 100.0, 200.0,  150.0, 1001)
lua:add_segment_with_code(                 300.0,  100.0, 1001)
lua:add_segment_with_code(                 400.0,    0.0, 1001)
lua:add_segment_with_code(                 500.0,  104.0, 1001)

lua:unstablefloor_segmentstrip(1000, 1001) --floorcode, segmentstrip code

lua:create_sprite("unstable_appear", ST_ANIMATED,"particle", 300.0,120) 
lua:sprite_shape("unstable_appear",ST_ANIMATED,64.0, 64.0)
lua:create_sprite("rumble", ST_ANIMATED,"purple_flame", 300.0,120) 
lua:sprite_shape("rumble",ST_ANIMATED,64.0, 64.0)
lua:create_sprite("unstable_dissappear", ST_ANIMATED,"particle", 300.0,120) 
lua:sprite_shape("unstable_dissappear",ST_ANIMATED,64.0, 64.0)

lua:unstablefloor_animations(1000,"unstable_appear","unstable_dissappear","rumble") --code, appear, disappear, rumble

lua:create_sound("appear","data/music/effect_stereo.ogg", 3000.0, 0.0, 0.0)
lua:create_sound("disappear","data/music/effect_stereo.ogg", 3000.0, 0.0, 0.0)
lua:create_music("rumble","data/music/disturbed.ogg")
lua:unstablefloor_audio(1000,"appear","disappear","rumble") --code, appear_sound, disappear_sound, rumble_sound

--unstablefloor end


--TRIGGERS start

--create shape
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,60.0) -- name, type, width, height
lua:shape_vertex("rectangle",2,120.0,0.0) --name, vertex num, x,y
lua:create_circle("circle",20.0, 123.0, 40.0) --name, x,y, radius
lua:circle_center("circle",40.0,-123.0) -- name , x,y
lua:circle_radius("circle",50.0) -- name, radius

--create trigger
lua:create_trigger("gate", TT_GATE, "data/scripts/test/srt_start_damage_test.lua","data/scripts/test/srt_stop_damage_test.lua",123.0,123.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
--lua:trigger_upload("gate",0) --name

lua:create_trigger("timed", TT_TIMER, "","", 0, 0) --name, type, on_time_script, nothing,none,none
lua:timed_trigger_repeat("timed",156.0, true) -- name, delay, repeat
lua:trigger_upload("timed",0) --name
--TRIGGERS end

--COLLIDER start
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,180.0) -- name, type, width, height
lua:create_collider(1111,"rectangle",400.0,20) --id, shape, x ,y

for i=0,200,20
do
    lua:create_circle("circle",20.0, 123.0, 40.0) --name, x,y, radius
    lua:circle_center("circle",40.0,-123.0) -- name , x,y
    lua:circle_radius("circle",50.0) -- name, radius
    lua:create_collider(i + 1000,"circle",-200.0,i) --id, shape, x ,y
end

--COLLIDER end

--TEXT start
lua:create_text("tuomo","comic_sans", 0.0, 0.0,0.1, 1.0) --name, font, x,y, delay, scale
lua:text_color("tuomo",0.0,0.0,0.0,1.0)
lua:add_text("tuomo", " !\"#$%`()*,-./")
lua:add_text("tuomo", "0123456789:;<=>")
lua:add_text("tuomo", "@ABCDEFGHIJKLMNO")
lua:add_text("tuomo", "PQRSTUVWXYZ[\] _")
lua:add_text("tuomo", "abcdefghijklmno")
lua:add_text("tuomo", "pqrstuvwxyz{ |}~|")
g_level.upload("tuomo",5,1)
lua:gameobject_remove_from_temp_list( "tuomo" )
--TEXT end

--REMORFABLE start
lua:create_sprite("lanterm", ST_TEXTURED,"lantern", 0.0, -64.0) 
lua:sprite_shape("lanterm",ST_TEXTURED,16.0, 32.0)
lua:textured_sprite_tex_coords("lanterm", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)
lua:remorfable_sprite("remo", "lanterm", 0.1, true)             -- name, sprite_name, speed, repeat

lua:add_key_frame(0.5, -128.0, 128.0, -0.5, 2.0)  -- adds a new key frame. time, x, y, rotation, scale
lua:add_key_frame_color(1.0,1.0,1.0,0.25)  -- r,g,b,a
lua:upload_key_frame("remo")

lua:add_key_frame(0.75, 128.0, 128.0, 1.5, 0.5)  -- adds a new key frame. time, x, y, rotation, scale
lua:add_key_frame_color(1.0,1.0,1.0,0.25)  -- r,g,b,a
lua:upload_key_frame("remo")

g_level.upload("remo",4)
--REOMRFABLE end

--LEVER start
--animated sprite creation
lua:create_sprite("door_open", ST_ANIMATED,"particle", 400.0,20) 
lua:sprite_shape("door_open",ST_ANIMATED,64.0, 64.0)
lua:create_sprite("door_close", ST_ANIMATED,"purple_flame", 400.0,20) 
lua:sprite_shape("door_close",ST_ANIMATED,64.0, 64.0)

lua:create_sprite("lever_open", ST_ANIMATED,"purple_flame", -550.0,20) 
lua:sprite_shape("lever_open",ST_ANIMATED,64.0, 64.0)
lua:create_sprite("lever_close", ST_ANIMATED,"particle", -550.0,20) 
lua:sprite_shape("lever_close",ST_ANIMATED,64.0, 64.0)
--sound creation
lua:create_sound("lever_sound_open","data/music/effect_stereo.ogg", 1.0, -550.0,20)  --name, music_name, radius, x,y
lua:create_sound("lever_sound_close","data/music/effect_stereo.ogg", 500.0, -550.0,20)  --name, music_name, radius, x,y
lua:create_sound("door_sound_open","data/music/effect_stereo.ogg", 2500.0, 400.0,20)  --name, music_name, radius, x,y
lua:create_sound("door_sound_close","data/music/effect_stereo.ogg", 2500.0, 400.0,20)  --name, music_name, radius, x,y

--lever door creation
lua:create_door("door","door_open","door_close","lever_sound_open","lever_sound_close",1111,true) --name, open animated sprite, close animated sprite, open_sound, close_sound,collider_id, is_closed
local door = g_level.upload("door",4)
lua:create_lever("lever","lever_open","lever_close","door_sound_open","door_sound_close",true) --name , open animated sprite, close animated sprite, open_sound, close_sound, is_closed
local lever = g_level.upload("lever",4)

lua:add_lever_door_signal(lever,true,door,true) --lever_id, lever_is_opened, door_id, door_is_opened
lua:add_lever_door_signal(lever,false,door,false) --lever_id, lever_is_opened, door_id, door_is_opened

--add trigger
lua:create_circle( "lever_shape", 0.0,0.0, 50.0)                                              --name, x, y, radius
lua:create_trigger("lever_trigger", TT_USE, "data/scripts/test/srt_use_lever.lua","",-550.0,20) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("lever_trigger", TT_USE, "lever_shape") --name, type, shape_name
lua:trigger_add_group_i_belong_to("lever_trigger", TT_USE, "everything") --name, type, group_name
lua:trigger_add_group_can_use_me("lever_trigger", TT_USE, "player") --name, type, group_name
lua:trigger_upload("lever_trigger",lever) --name

--LEVER stop

--MUSIC start
lua:do_file("data/scripts/test/music_examples.lua")
--MUSIC stop

--DIALOG start
lua:do_file("data/scripts/test/dialog_example.lua")
--DIALOG ends


--lua:do_file("data/scripts/test/srt_flying_leaf_test.lua")

lua_init_texture_animation("damage","data/images/effects/damage/", 2, MODE_LOOP, DIRECTION_FORWARD, 0.3, FM_NEAREST, WM_CLAMP, WM_CLAMP, AM_MODULATE)
lua:create_sprite("damma", ST_ANIMATED,"damage", 0.0, 0.0) 
lua:sprite_shape("damma",ST_ANIMATED,64.0, 64.0)
g_level.upload("damma",4)

--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player_trigger.lua",0)
lua:init_camera_binder(-700.0, 1800.0, -400.0, 500.0) -- left, right, bottom, up
lua:upload_player_to_layer(5)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, -500.0, 260.0) -- set the player to it's right position
--Player end

lua:set_game_state(GS_DIALOG) -- sets the game state to menu. thus you are able to use the menu commands